<?php if(!defined('IN_GS')){ die('you cannot load this page directly.'); }
/****************************************************
*
* @File:         template.php
* @Package:      GetSimple
* @Action:       Charity theme for GetSimple CMS
*

*****************************************************/
?>

<!DOCTYPE html>

<html lang=en>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1" />
<title>
<?php get_page_clean_title(); ?>
&mdash;
<?php get_site_name(); ?>
</title>
<?php get_header(); ?>
<link href="<?php get_theme_url(); ?>/css/style.css" rel="stylesheet" type="text/css" media="screen" />
<link href="<?php get_theme_url(); ?>/css/sidr.css" rel="stylesheet" type="text/css" media="screen" />
<link href="<?php get_theme_url(); ?>/css/owl.carousel.css" rel="stylesheet" type="text/css" media="screen" />
<link href="<?php get_theme_url(); ?>/css/fontawesome.css" rel="stylesheet" type="text/css" media="screen" />
<script src="<?php get_theme_url(); ?>/js/jquery-1.8.2.min.js"></script>

<!-- Fonts -->
<link href="http://fonts.googleapis.com/css?family=Hind:400,600,700,500" rel="stylesheet" type="text/css" />
<link href='http://fonts.googleapis.com/css?family=Oswald:400,300,700' rel='stylesheet' type='text/css' />
</head>

<body id="<?php get_page_slug(); ?>" >

<!-- Header -->

<div class="header">
  <div class="container">
    <div class="logo">
      <h1><a href="<?php get_site_url(); ?>">
        <?php get_site_name(); ?>
        </a></h1>
    </div>
    <div id="mobile-header"> <a id="responsive-menu-button" href="#sidr-main"><img src="<?php get_theme_url(); ?>/images/menu.png"></a> </div>
    <nav class="nav">
      <div class="mainMenu">
        <ul>
          <?php get_navigation(return_page_slug()); ?>
        </ul>
      </div>
    </nav>
    <div class="socialMedia">
      <?php get_component('socialmedia'); ?>
    </div>
  </div>
</div>


<!-- ContentArea -->
<section class="content">
  <div class="container">
  <h1>
      <?php get_page_title(); ?>
    </h1>
      <?php get_page_content(); ?>
  </div>
</section>

<!-- footer -->
<footer class="footer">
  <div class="container">
    <div class="sidebar left">
      <div class="sidebarRight">
        <?php get_component('footercontent'); ?>
      </div>
      <div class="sidebarLeft">
        <h3>
          <?php  get_site_name(); ?>
        </h3>
        <?php get_component('footercontact'); ?>
      </div>
    </div>
    <p align="center">&copy; <?php echo date('Y'); ?>
      <?php  get_site_name(); ?>
      |
      <?php get_site_credits(); ?>
      Theme by <a href="http://tnerb.com" target="_blank">tnerb.com</a>
      <?php get_footer(); ?>
    </p>
  </div>
</footer>


<!-- end-of-"page" --> 

<script src="<?php get_theme_url(); ?>/js/owl.carousel.js"></script><script>
    $(document).ready(function() {
      var owl = $("#homeSlider");
      owl.owlCarousel({
        autoPlay : 5000 ,
		navigation : true,
		pagination : false,
        singleItem : true,
        transitionStyle : "fade",
		autoHeight : true,
        lazyEffect : "fade"
      });
    });
</script> 
<script src="<?php get_theme_url(); ?>/js/sidr.js"></script> 
<script> jQuery('#responsive-menu-button').sidr({ name: 'sidr-main', source: '.mainMenu' }); </script> 
<script src="<?php get_theme_url(); ?>/js/scripts.js"></script>
</body>
</html>