<?php
/*****************************/
/** Theme's current version **/
/*****************************/
$theme_ver = "0.1.2";
/*****************************/
	global $TEMPLATE, $SITENAME, $SITEURL;
	$template = $TEMPLATE.'/less';
	$template_file = 'variables.less';
	$templates = directoryToArray(GSTHEMESPATH . $template . '/', true);
	
	if (isset($_GET['t'])) {
		$_GET['t'] = strippath($_GET['t']);
		if ($_GET['t']&&is_dir(GSTHEMESPATH . $_GET['t'].'/')) {
			$template = $_GET['t'];
		}
	}
	if (isset($_GET['f'])) {
		$_GET['f'] = $_GET['f'];
		if ($_GET['f']&&is_file(GSTHEMESPATH . $template.'/'.$_GET['f'])) {
			$template_file = $_GET['f'];
		}
	}
	
	if((isset($_POST['edit_file']))){
		if (isset($_POST['f'])) {
			$editing = $_POST['f'];
			if ($editing && is_file(GSTHEMESPATH . $template.'/'.$editing)) {
				$template_file = $editing;
			}
		}
	}
	
	$themepath = GSTHEMESPATH.$template.DIRECTORY_SEPARATOR;
	if(!filepath_is_safe($themepath.$template_file,GSTHEMESPATH,true)) die();

	# check for form submission
	if((isset($_POST['submitsave']))){
		# check for csrf
		if (!defined('GSNOCSRF') || (GSNOCSRF == FALSE) ) {
			$nonce = $_POST['nonce'];
			if(!check_nonce($nonce, "save")) {
				die("CSRF detected!");
			}
		}
		# save edited template file
		$SavedFile = $_POST['edited_file'];
		$FileContents = get_magic_quotes_gpc() ? stripslashes($_POST['content']) : $_POST['content'];	
		$fh = fopen(GSTHEMESPATH . $SavedFile, 'w') or die("can't open file");
		fwrite($fh, $FileContents);
		fclose($fh);
		$success = sprintf(i18n_r('TEMPLATE_FILE'), $SavedFile); ?>
		<script>
			var text = '<?php echo $success; ?>';
			$('.bodycontent').before($('<div class="updated" style="display: block;" ><p>'+text+'</p></div>'));
		</script>
		<?php
	}
	
	function get_css($filename) {
		global $TEMPLATE;
		if(file_exists(GSTHEMESPATH . $TEMPLATE ."/less/".$filename)) {
			$less = new lessc;
			$text = $less->compileFile(GSTHEMESPATH . $TEMPLATE ."/less/".$filename);
			return $text;
		}
	}
	
	if((isset($_POST['generate_css']))){
		require GSTHEMESPATH . $TEMPLATE .'/inc/lessc.inc.php';
		$myfile = fopen(GSTHEMESPATH . $TEMPLATE ."/css/style.css", "w") or die("Unable to open file!");
		$txt = get_css("main.less");
		if((isset($_POST['extendcss']))) $txt .= get_css("extend.less");
		if((isset($_POST['tabs']))) $txt .= get_css("tabs.less");
		if((isset($_POST['animblocks']))) $txt .= get_css("animblocks.less");
		if((isset($_POST['alertcs']))) $txt .= get_css("alerts.less");
		if((isset($_POST['imgtool']))) $txt .= get_css("img_tool.less");
		if((isset($_POST['labels']))) $txt .= get_css("labels.less");
		if((isset($_POST['modals']))) $txt .= get_css("modals.less");
		if((isset($_POST['pagination']))) $txt .= get_css("pagination.less");
		if((isset($_POST['progressb']))) $txt .= get_css("progress_bar.less");
		if((isset($_POST['tablescss']))) $txt .= get_css("tables.less");
		if((isset($_POST['tooltipcs']))) $txt .= get_css("tooltip.less");
		if((isset($_POST['controlsxt']))) $txt .= get_css("css_controls.less");
		if((isset($_POST['slidersimple']))) $txt .= get_css("csslider_simple.less");
		if((isset($_POST['sliderext']))) $txt .= get_css("csslider_ext.less");
		if((isset($_POST['animbuttons']))) $txt .= get_css("animbuttons.less");
		if((isset($_POST['texteffects']))) $txt .= get_css("anim_text.less");
		if((isset($_POST['fontawe']))) $txt .= get_css("font_awesome.less");
		if((isset($_POST['fontawe_not']))) $txt .= get_css("fa_icons.less");
		if((isset($_POST['minify_css']))){
			$txt = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $txt);
			$txt = str_replace(': ', ':', $txt);
			$txt = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $txt);
		}
		fwrite($myfile, $txt);
		fclose($myfile);
		$success = sprintf(i18n_r('CLONE_SUCCESS'), '<b>'.$TEMPLATE .'/css/style.css</b>'); ?>
		<script>
			var text = '<?php echo $success; ?>';
			$('.bodycontent').before($('<div class="updated" style="display: block;" ><p>'+text+'</p></div>'));
		</script>
		<?php
	}

	$theme_templates = '<span id="themefiles"><select class="text" id="theme_files" style="width:425px;" name="f" >';
	$allowed_extensions=array('less');
	foreach ($templates as $file){
		$extension=pathinfo($file,PATHINFO_EXTENSION);
		if (in_array($extension, $allowed_extensions)){
			$filename=pathinfo($file,PATHINFO_BASENAME);
			$filenamefull=substr(strstr($file,'/theme/'.$template.'/'),strlen('/theme/'.$template.'/'));
			if ($template_file == $filenamefull){ 
				$sel='selected="selected"'; 
			} else { 
				$sel="";
			}
			$theme_templates .= '<option '.$sel.' value="'.$filenamefull.'" >'.$filenamefull.'</option>';
		}
	}
	$theme_templates .= "</select></span>";
?>
<style>
	.CodeMirror {border: 2px solid #ddd; line-height: 1.2; width: 630px;}
	.less-legend {font-size: 14px;margin: 0 10px;padding: 4px;color: #CF3805;}
</style>
<link href="../theme/<?php echo $TEMPLATE; ?>/inc/codemirror/codemirror.css" rel="stylesheet">
<script src="../theme/<?php echo $TEMPLATE; ?>/inc/codemirror/codemirror.min.js"></script>
<div class="theme-version">Theme Skeleton-FX version <?php echo $theme_ver; ?></div>
<fieldset style="margin-bottom:20px;padding: 5px;">
	<legend class="less-legend">LESS <?php echo i18n('FILE_MANAGEMENT'); ?></legend>
	<div class="widesec" style="margin:20px 0">
		<form action="<?php myself(); ?>?id=theme_settings" method="post" accept-charset="utf-8" >
			<p style="padding: 0 10px;"><?php echo $theme_templates; ?>&nbsp;&nbsp;&nbsp;<input class="submit" type="submit" name="edit_file" value="<?php i18n('EDIT'); ?>" /></p>
		</form>
		<p style="padding: 0 10px;"><b><?php i18n('EDITING_FILE'); ?>:</b> <code><?php echo $SITEURL.'theme/'. tsl($template) .'<b>'. $template_file; ?></b></code></p>
		<?php $content = file_get_contents(GSTHEMESPATH . tsl($template) . $template_file); ?>
		<form action="<?php myself(); ?>?id=theme_settings&amp;t=<?php echo $template; ?>&amp;f=<?php echo $template_file; ?>" method="post" >
			<input id="nonce" name="nonce" type="hidden" value="<?php echo get_nonce("save"); ?>" />
			<textarea id="code" name="content" wrap='off'><?php echo htmlentities($content, ENT_QUOTES, 'UTF-8'); ?></textarea>
			<input type="hidden" value="<?php echo tsl($template) . $template_file; ?>" name="edited_file" />
			<p id="submit_line" style="padding: 0 10px;">
				<span><input class="submit" type="submit" name="submitsave" value="<?php i18n('BTN_SAVECHANGES'); ?>" /></span> &nbsp;&nbsp;<?php i18n('OR'); ?>&nbsp;&nbsp; <a class="cancel" href="load.php?id=theme_settings&cancel"><?php i18n('CANCEL'); ?></a>
			</p>
		</form>
	</div>
</fieldset>
<fieldset style="margin:20px 0 20px -8px;position: relative;">
	<legend class="less-legend"><?php echo i18n('SETTINGS'); ?> style.css</legend>
	<div class="widesec" style="margin:20px 0">
		<input type='button' id='selectall' value="Select All" style="position: absolute;top: -10px;right: 2px;">
		<form action="<?php myself(); ?>?id=theme_settings" method="post" accept-charset="utf-8" >
			<div style="padding: 10px;" id="lesstocss">
				<div class="width-1-4" title="Search Form, Buttons, Scroll to Top, Menu Animations"><input type="checkbox" id="extend_css" name="extendcss" value=1 <?php echo return_theme_setting('extendcss')==1?"checked":"" ?>><label for="extend_css" class="ra-settings">Extend CSS</label></div>
				<div class="width-1-4"><input type="checkbox" id="tabs" name="tabs" value=1 <?php echo return_theme_setting('controlscss')==1?"checked":"" ?>><label for="tabs" class="ra-settings">Accordion & Tabs</label></div>
				<div class="width-1-4"><input type="checkbox" id="alertcs" name="alertcs" value=1 <?php echo return_theme_setting('controlscss')==1?"checked":"" ?>><label for="alertcs" class="ra-settings">Alerts CSS</label></div>
				<div class="width-1-4"><input type="checkbox" id="anim_blocks" name="animblocks" value=1 <?php echo return_theme_setting('controlscss')==1?"checked":"" ?>><label for="anim_blocks" class="ra-settings">Animated Blocks</label></div>
				<div style="clear: both;"></div>
				<div class="width-1-4"><input type="checkbox" id="controlsxt" name="controlsxt" value=1 <?php echo return_theme_setting('controlscss')==1?"checked":"" ?>><label for="controlsxt" class="ra-settings">Form Controls Ext</label></div>
				<div class="width-1-4"><input type="checkbox" id="img_tool" name="imgtool" value=1 <?php echo return_theme_setting('controlscss')==1?"checked":"" ?>><label for="img_tool" class="ra-settings">Image Tools</label></div>
				<div class="width-1-4"><input type="checkbox" id="labels" name="labels" value=1 <?php echo return_theme_setting('controlscss')==1?"checked":"" ?>><label for="labels" class="ra-settings">Labels & Badges</label></div>
				<div class="width-1-4"><input type="checkbox" id="modals" name="modals" value=1 <?php echo return_theme_setting('controlscss')==1?"checked":"" ?>><label for="modals" class="ra-settings">Modal Windows</label></div>
				<div style="clear: both;"></div>
				<div class="width-1-4"><input type="checkbox" id="pagination" name="pagination" value=1 <?php echo return_theme_setting('controlscss')==1?"checked":"" ?>><label for="pagination" class="ra-settings">Pagination</label></div>
				<div class="width-1-4"><input type="checkbox" id="progressb" name="progressb" value=1 <?php echo return_theme_setting('controlscss')==1?"checked":"" ?>><label for="progressb" class="ra-settings">Progress Bars</label></div>
				<div class="width-1-4"><input type="checkbox" id="tablescss" name="tablescss" value=1 <?php echo return_theme_setting('controlscss')==1?"checked":"" ?>><label for="tablescss" class="ra-settings">Tables CSS</label></div>
				<div class="width-1-4"><input type="checkbox" id="tooltipcs" name="tooltipcs" value=1 <?php echo return_theme_setting('controlscss')==1?"checked":"" ?>><label for="tooltipcs" class="ra-settings">ToolTips</label></div>
				<div style="clear: both;"></div>
				<div class="width-1-4"><input type="checkbox" id="slidersimple" name="slidersimple" value=1 <?php echo return_theme_setting('slidersimplecss')==1?"checked":"" ?>><label for="slidersimple" class="ra-settings">Simple Slider</label></div>
				<div class="width-1-4"><input type="checkbox" id="sliderext" name="sliderext" value=1><label for="sliderext" class="ra-settings">Extended Slider</label></div>
				<div class="width-1-4"><input type="checkbox" id="texteffects" name="texteffects" value=1><label for="texteffects" class="ra-settings">Text Effects</label></div>
				<div class="width-1-4"><input type="checkbox" id="animbuttons" name="animbuttons" value=1><label for="animbuttons" class="ra-settings">Animated Buttons</label></div>
				<div style="clear: both;"></div>
				<div class="width-1-4"><input type="checkbox" id="fontawe" name="fontawe" value=1><label for="fontawe" class="ra-settings">FontAwesome</label></div>
				<div class="width-1-2" title="Include all FontAwesome Icons implementation"><input type="checkbox" id="fontawe_not" name="fontawe_not" value=1><label for="fontawe_not" class="ra-settings">All FA Icons</label></div>
				<p style="padding: 0 10px;margin: 20px 0 0 0;clear: both;">
					<input type="checkbox" id="minify_css" name="minify_css" value=0 checked ><label for="minify_css" class="ra-settings">Minify CSS file</label>
					<input class="submit" type="submit" name="generate_css" value="<?php echo mb_strtoupper(mb_substr(i18n_r('RECREATE'), 0, 1)).mb_substr(i18n_r('RECREATE'), 1); ?>" />
				</p>
			</div>
		</form>
	</div>
</fieldset>
<script type="text/javascript">
var editor = CodeMirror.fromTextArea(document.getElementById("code"), {
	lineNumbers : true,
	matchBrackets : true,
	indentUnit: 4,
	indentWithTabs: true,
	enterMode: "keep",
	mode: "text/x-less",
	tabMode: "shift",
	theme:'default'
});
$(function () {
    $('#selectall').toggle(
        function() {
            $('#lesstocss input:checkbox').prop('checked', true);
			$(this).val('Uncheck All');
        },
        function() {
            $('#lesstocss input:checkbox').prop('checked', false);
			$(this).val('Select All');
        }
    );
});
</script>